/**
 * \file: InputSourceChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: android auto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_INPUTSOURCE_CHANNEL_H
#define AAUTO_INPUTSOURCE_CHANNEL_H

#include <adit_logging.h>
#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>

#include "aauto/AditInputSource.h"
#include "aauto/AautoErrorCodes.h"

/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>

#include "utils/IConfiguration.h"

namespace adit { namespace aauto {

class InputSourceChannel : public IAditInputSourceCallbacks
{
public:
    InputSourceChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId,
                            t_ilm_layer inLayerID, t_ilm_surface inSurfaceID, IDynamicConfiguration& inConfig);
    ~InputSourceChannel();
    bool Initialize();
    void shutdown();
    void onInputFeedback(const InputFeedback& inFeedback);
    void notifyErrorCallback(aautoErrorCodes inErrorCode);
    ::shared_ptr<AditInputSource> getProtocolEndpoint()
    {
        return input;
    }

private:
    ::shared_ptr<GalReceiver> receiver;
    uint8_t sessionId;
    t_ilm_layer layerID;
    t_ilm_surface surfaceID;
    IDynamicConfiguration* mConfig;

    ::shared_ptr<AditInputSource> input;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_INPUTSOURCE_CHANNEL_H */
